/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings.registry;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public class BuildingEntry
extends ForgeRegistryEntry<BuildingEntry> {
    private final AbstractBlockHut<?> buildingBlock;
    private final BiFunction<IColony, BlockPos, IBuilding> buildingProducer;
    private List<Supplier<IBuildingModule>> buildingModuleProducers;
    private List<Supplier<Supplier<IBuildingModuleView>>> buildingModuleViewProducers;
    private final Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer;

    public AbstractBlockHut<?> getBuildingBlock() {
        return this.buildingBlock;
    }

    public IBuilding produceBuilding(BlockPos position, IColony colony) {
        IBuilding building = this.buildingProducer.apply(colony, position);
        for (Supplier<IBuildingModule> module : this.buildingModuleProducers) {
            building.registerModule(module.get().setBuilding(building));
        }
        return building;
    }

    public IBuildingView produceBuildingView(BlockPos position, IColonyView colony) {
        IBuildingView buildingView = this.buildingViewProducer.get().apply(colony, position);
        for (Supplier<Supplier<IBuildingModuleView>> module : this.buildingModuleViewProducers) {
            buildingView.registerModule(module.get().get());
        }
        return buildingView;
    }

    public List<Supplier<IBuildingModule>> getModuleProducers() {
        return this.buildingModuleProducers;
    }

    public List<Supplier<Supplier<IBuildingModuleView>>> getModuleViewProducers() {
        return this.buildingModuleViewProducers;
    }

    private BuildingEntry(AbstractBlockHut<?> buildingBlock, BiFunction<IColony, BlockPos, IBuilding> buildingProducer, Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer, List<Supplier<IBuildingModule>> buildingModuleProducers, List<Supplier<Supplier<IBuildingModuleView>>> buildingModuleViewProducers) {
        this.buildingBlock = buildingBlock;
        this.buildingProducer = buildingProducer;
        this.buildingViewProducer = buildingViewProducer;
        this.buildingModuleProducers = buildingModuleProducers;
        this.buildingModuleViewProducers = buildingModuleViewProducers;
    }

    public static final class Builder {
        private AbstractBlockHut<?> buildingBlock;
        private BiFunction<IColony, BlockPos, IBuilding> buildingProducer;
        private Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer;
        private List<Supplier<IBuildingModule>> buildingModuleProducers = new ArrayList<Supplier<IBuildingModule>>();
        private List<Supplier<Supplier<IBuildingModuleView>>> buildingModuleViewProducers = new ArrayList<Supplier<Supplier<IBuildingModuleView>>>();
        private ResourceLocation registryName;

        public Builder setBuildingBlock(AbstractBlockHut<?> buildingBlock) {
            this.buildingBlock = buildingBlock;
            return this;
        }

        public Builder setBuildingProducer(BiFunction<IColony, BlockPos, IBuilding> buildingProducer) {
            this.buildingProducer = buildingProducer;
            return this;
        }

        public Builder setBuildingViewProducer(Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer) {
            this.buildingViewProducer = buildingViewProducer;
            return this;
        }

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public BuildingEntry createBuildingEntry() {
            Validate.notNull(this.buildingBlock);
            Validate.notNull(this.buildingProducer);
            Validate.notNull(this.buildingViewProducer);
            Validate.notNull((Object)this.registryName);
            return (BuildingEntry)new BuildingEntry(this.buildingBlock, this.buildingProducer, this.buildingViewProducer, this.buildingModuleProducers, this.buildingModuleViewProducers).setRegistryName(this.registryName);
        }

        public Builder addBuildingModuleProducer(Supplier<IBuildingModule> moduleProducer) {
            this.buildingModuleProducers.add(moduleProducer);
            return this;
        }

        public Builder addBuildingModuleViewProducer(Supplier<Supplier<IBuildingModuleView>> moduleViewProducer) {
            this.buildingModuleViewProducers.add(moduleViewProducer);
            return this;
        }

        public Builder addBuildingModuleProducer(Supplier<IBuildingModule> moduleProducer, Supplier<Supplier<IBuildingModuleView>> moduleViewProducer) {
            this.buildingModuleProducers.add(moduleProducer);
            this.buildingModuleViewProducers.add(moduleViewProducer);
            return this;
        }
    }
}

